﻿/* Copyright 2016, Kasyan Servetsky
October 3, 2016
Written by Kasyan Servetsky
http://www.kasyan.ho.com.ua
e-mail: askoldich@yahoo.com */
//======================================================================================
var scriptName = "Make hyperlinks",
set, doc, swatchOK,
count = 0;

PreCheck();

//===================================== FUNCTIONS  ======================================
function Main() {
	app.findGrepPreferences = app.changeGrepPreferences = NothingEnum.NOTHING;
	app.findGrepPreferences.findWhat = "\\d+";
	app.findGrepPreferences.appliedCharacterStyle = "Page Number";
	var foundItems = doc.findGrep(true);
	app.findGrepPreferences = app.changeGrepPreferences = NothingEnum.NOTHING;

	if (foundItems.length == 0) ErrorExit("No page numbers were found in the current document.", true);
	
	for (var f = 0; f < foundItems.length; f++) {
		try {
			var sourceTextRef = foundItems[f];
			
			if (sourceTextRef.fillColor != swatchOK) {
				MakeHyperlink(sourceTextRef);
			}
		}
		catch(err) {
			$.writeln(err.message + ", line: " + err.line);
		}
	}
	
	var report = count + " hyperlink" + ((count == 1) ? " was" : "s were") + " created.";
	alert("Finished. " + report, scriptName);
}
//--------------------------------------------------------------------------------------------------------------------------------------------------------
function MakeHyperlink(sourceTextRef) {
	var source, destination, hyperlink,
	pageNum = sourceTextRef.contents,
	obj = GetPage(pageNum);
	
	if (obj != null) {
		source = doc.hyperlinkTextSources.add(sourceTextRef);
		destination = obj.docDest.hyperlinkPageDestinations.add(obj.page);
		
		var name = "Page_" + pageNum;

		if (!doc.hyperlinks.itemByName(name).isValid) {
			hyperlink = doc.hyperlinks.add(source, destination, {name: name});
		}
		else {
			hyperlink = doc.hyperlinks.add(source, destination, {name: name + "_" + String(Math.random()).replace(/^0\./, "")});
		}
	
		if (hyperlink.isValid) {
			count++;
			sourceTextRef.fillColor = swatchOK;
		}
	}
}
//--------------------------------------------------------------------------------------------------------------------------------------------------------
function GetPage(pageNum) {
	var obj = null;
	
	for (var i = 0; i < app.documents.length; i++) {
		if (app.documents[i].pages.itemByName(pageNum).isValid) {
			obj = {page: app.documents[i].pages.itemByName(pageNum), docDest: app.documents[i]};
			break;
		}
	}
	
	return obj;	
}
//--------------------------------------------------------------------------------------------------------------------------------------------------------
function CheckSwatches() {
	if (doc.swatches.itemByName("===== OK =====") == null) {
		swatchOK = doc.colors.add({name : "===== OK =====", model : ColorModel.PROCESS, space : ColorSpace.RGB, colorValue : [0, 255, 0]});
	}
	else {
		swatchOK = doc.swatches.itemByName("===== OK =====");
	}
}
//--------------------------------------------------------------------------------------------------------------------------------------------------------
function PreCheck() {
	if (app.documents.length == 0) ErrorExit("Please open a document and try again.", true);
	doc = app.activeDocument;
	if (!app.activeDocument.saved) ErrorExit("The current document has not been saved since it was created. Please save the document and try again.", true);
	CheckSwatches();
	Main();
}
//--------------------------------------------------------------------------------------------------------------------------------------------------------
function ErrorExit(error, icon) {
	alert(error, scriptName, icon);
	exit();
}
//--------------------------------------------------------------------------------------------------------------------------------------------------------